﻿<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS Z-03</title>
		<script runat="server">

	//Dzień do któego zalicza się wypłaty za poprzedni kwartał
	static readonly int dataGraniczna = 11;
	
	//Jeżeli ustawiony true, to wszystkie liczby podawane bez zaokrąglenia
    static bool debug = false;

    //Po ustawieniu na true raport zostanie przygotowany dla pracowników zwróconych
    //przez listę a nie dla wszystkich
    static bool wglisty = false;
		    
    static string traceName = "";

    [DefaultWidth(10)]
    public enum Kwartał {
        Pierwszy    = 1,
        Drugi       = 2,
        Trzeci      = 3,
        Czwarty     = 4,
    }
    
    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = Date.Today;
            rok = data.Year;
            int m = data.Month-1;
            kwartał = (Kwartał)(m/3)+1;
            if ((m%3)==0) {
                kwartał-=1;
                if (kwartał==0) {
                    kwartał = Kwartał.Czwarty;
                    rok--;
                }
            }
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        Kwartał kwartał;
        [Priority(2)]
        [Required]
        public Kwartał Kwartał {
            get { return kwartał; }
            set {
                kwartał = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        [Priority(3)]
        [Browsable(false)]
        public int Months {
            get { return (int)kwartał * 3; }
        }
    
        [Priority(4)]
        [Caption("Raport za okres")]
        public FromTo Okres {
            get {
                Date from = new Date(rok, 1, 1);
                Date to = new Date(rok,(int)kwartał * 3 + 1, 1)-1;
                return new FromTo(from, to);
            }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }
    
    class Total {
        public readonly string pkd;
        readonly Params pars;
        decimal etaty;
        public int osoby;
        public Time czas;
        public decimal brutto;
        public decimal spółdzielnie;
        public decimal budżet;
        public decimal zus;
        public decimal fis;
    
        decimal[] wymiar = new decimal[12];
        int[] days = new int[12];
    
        public Total(string pkd, Params pars) {
            this.pkd = pkd;
            this.pars = pars;
            int y = pars.Okres.From.Year;
            for (int m=1; m<=12; m++) {
                YearMonth ym = new YearMonth(y, m);
                days[m-1] = ym.Days;
            }
        }
        
        public void AddBrutto(Pracownik p) {
            foreach (WypElement e in Elementy(p))
                if (e.Wyplata.Typ!=TypWyplaty.Umowa 
                    && !e.ZasiłekBudżet 
                    && !e.ZasiłekZus 
                    && e.Definicja.Info.Opodatkowany
                    && e.Definicja.GUS.WykazujNaDeklaracjach
                ) {
					PracHistoria ph = e.PracHistoria;
					if ((ph.Etat.RodzajZatrudnienia==RodzajZatrudnienia.NieDotyczy || ph.Etat.RodzajZatrudnienia==RodzajZatrudnienia.PracownikTymczasowy) && (ph.Etat.OkresZatrudnienia*pars.Okres)!=FromTo.Empty) {
						switch (e.Definicja.GUS.Kategoria) {
							case KategoriaWynagrodzeniaGUS.WypłataUdziałWZysku:
								spółdzielnie += e.Wartosc; break;
							case KategoriaWynagrodzeniaGUS.DodatkoweWynagrodzenieRoczne:
								budżet += e.Wartosc; break;
						}
						brutto += e.Wartosc;
						zus += e.Podatki.KosztyZUS;
                        //TID: 3997
                        //fis += e.Podatki.ZalFIS + e.Podatki.ZdrowotneFaktycznieOdliczon e;
                        fis += e.Podatki.NalFIS;
                    }
                }
        }
        
		ICollection AktualnyOkres(Pracownik p) {
            Trace("Aktualny okres: " + pars.Okres);
			ArrayList result = new ArrayList();
			
			//Elementy za okres sprawozawczy wypłacone do 11 dnia następnego okresu
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgPracownik[p];
			st = new SubTable(st, pars.Okres);
			FromTo ow1 = new FromTo(pars.Okres.From, pars.Okres.To + dataGraniczna);
			foreach (WypElement e in st)
                if (ow1.Contains(e.Data)) {
                    result.Add(e);
                    Trace(string.Format("{0}, za okres: {1}, data wypłaty: {2}, wartość: {3}", e.Definicja.Nazwa, e.Okres, e.Data, e.Wartosc));
                }
					
			return result;
		}
		
		ICollection PoparzedniOkres(Pracownik p) {
            ArrayList result = new ArrayList();
			
			//Wypłaty wypłacone po 11 dniu okresu sprawozdawczego za okresy poprzednie
			FromTo ow1 = new FromTo(new Date(pars.Okres.From + dataGraniczna), Date.MaxValue);
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgDaty[p];
			st = new SubTable(st, ow1);
			FromTo ow2 = new FromTo(Date.MinValue, pars.Okres.From-1);
            Trace("Poprzedni okres: " + ow1 + "/" + ow2);
            foreach (WypElement e in st)
                if (ow2.Contains(e.Okres.To)) {
                    result.Add(e);
                    Trace(string.Format("{0}, za okres: {1}, data wypłaty: {2}, wartość: {3}", e.Definicja.Nazwa, e.Okres, e.Data, e.Wartosc));
                }
					
			return result;
		}
		
		protected IEnumerable Elementy(Pracownik p) {
			ArrayList result = new ArrayList();
			result.AddRange(AktualnyOkres(p));
			result.AddRange(PoparzedniOkres(p));
			return result;
		}
    
        //Do etatów wliczamy pracowników (bez uczniów, chałupników, agentów i pracowników
        //zatrudnionych za granicą) --> RodzajZatrudnienia=Nie dotyczy
        //Pomijamy okresy urlopów bezpłatnych.
    
        public void AddEtaty(PracHistoria ph, KalkulatorPracy kalk) {
            if (ph.Etat.RodzajZatrudnienia!=RodzajZatrudnienia.NieDotyczy && ph.Etat.RodzajZatrudnienia!=RodzajZatrudnienia.PracownikTymczasowy)
                return;
    
            FromTo zatr = ph.Etat.EfektywnyOkres * pars.Okres;
            if (zatr==FromTo.Empty)
                return;
    
            Periods p = zatr.ToPeriods();
            foreach (INieobecnosc n in kalk.Nieobecnosci(zatr, true))
                if (n.Definicja.Przyczyna==PrzyczynaNieobecnosci.UrlopBezpłatny)
                    p -= n.Okres;
    
            decimal w = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
    
            czas += kalk.Praca(p).Czas;
            p = p.BreakByMonth();
    
            foreach (FromTo o in p) {
                int m = o.From.Month-1;
                wymiar[m] += w * o.Days / days[m];
            }    
        }
    
        public void AddOsoby(PracHistoria ph, KalkulatorPracy kalk) {
            if (!ph.GUS.GlowneMiejscePracy || !ph.Etat.EfektywnyOkres.Contains(pars.Okres.To))
                return;
    
            switch (ph.Etat.RodzajZatrudnienia) {
            case RodzajZatrudnienia.NieDotyczy:
            case RodzajZatrudnienia.PracownikTymczasowy:
            case RodzajZatrudnienia.PracownikZaGranicą:
            case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
            case RodzajZatrudnienia.CzłonekRSP:
            case RodzajZatrudnienia.CzłonekSKR:
            case RodzajZatrudnienia.Chałupnik:
            case RodzajZatrudnienia.Właściciel:
            case RodzajZatrudnienia.OsobaWspółpracująca:
            //Agent
                break;
            default:
                return;
            }
    
            if (!Nieobecny(ph.Pracownik, kalk, pars.Okres.To))
                osoby++;
        }
    
        bool Nieobecny(Pracownik pracownik, KalkulatorPracy kalk, Date to) {
            Periods periods = Periods.Empty;
            Date from = new Date(to.Year, to.Month-2, 1);
            FromTo okres = new FromTo(from, to);
            //1. Wyliczamy ostatni ciągły okres zatrudnienia za ostatnie 3 miesiące
            foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
                periods += ph.Etat.EfektywnyOkres;
            periods = (periods*okres).ToFlat();
            if (periods==Periods.Empty)
                okres = FromTo.Empty;
            else
                okres = periods[periods.Count-1];
            //2. Wycinamy z niego nieobecności typu urlop bezpłatny i wychowawczy
            periods = Periods.New(okres);
            foreach (INieobecnosc n in kalk.Nieobecnosci(okres, true))
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                        periods -= n.Okres;
                        break;
                }
            return periods==Periods.Empty;
        }
    
        public object Etaty {
            get {
                decimal w = 0;
                decimal m = pars.Months;
                for (int i=0; i<m; i++)
                    w += wymiar[i];
                w /= m;
                if (debug)
					return Soneta.Tools.Math.Round(w, 2);
                return (int)Soneta.Tools.Math.Round(w);
            }
        }
    }

    static Log trace;
		    
    void dc_ContextLoad(Object sender, EventArgs e) {
        trace = null;
        if (traceName != "")
            trace = new Log(traceName, true);        
        
        ReportHeader["ROK"] = pars.Rok.ToString();
        ReportHeader["KWARTAŁ"] = pars.Kwartał.ToString();
    
        string pkdFirmy = CoreModule.GetInstance(dc).Config.Firma.Pieczątka.PKD;
		Total total = new Total(pkdFirmy, pars);		
        KadryModule kadry = KadryModule.GetInstance(dc);
        FromTo okres = pars.Okres;

        Log log = new Log();
        int m;
        int l = 0;
        
        IEnumerable pracownicy;
        if (wglisty) {
            ArrayList lista = new ArrayList();
            foreach (Pracownik idx in (Row[])dc[typeof(Row[])])
                lista.Add(idx);
            pracownicy = lista;
            m = lista.Count;
        }
        else {
            Soneta.Business.View view = kadry.Pracownicy.CreateView();
            view.ForceAllRows();
            m = view.Count;
            pracownicy = view;
        }

        foreach (Pracownik p in pracownicy) {
            Trace(p);
            log.WriteLine(new Percent(++l, m));
            log.WriteLine(p);            
            
            KalkulatorPracy kalk = new KalkulatorPracy(p);
            foreach (PracHistoria ph in p.Historia.GetIntersectedRows(okres)) {
                total.AddEtaty(ph, kalk);
                total.AddOsoby(ph, kalk);
            }
            total.AddBrutto(p);
        }
    
		pkd.EditValue = total.pkd=="" ? "&nbsp;" : total.pkd;
		etaty.EditValue = total.Etaty;
		osoby.EditValue = total.osoby;
		czas.EditValue = Czas(total.czas);
		brutto.EditValue = Tys(total.brutto);
		spółdzielnie.EditValue = Tys(total.spółdzielnie);
		budżet.EditValue = Tys(total.budżet);
		zus.EditValue = Tys(total.zus);
		fis.EditValue = Tys(total.fis);
    }
    
    public decimal Tys(decimal value) {
		if (debug)
			return value;
		return Soneta.Tools.Math.Round(value/1000m, 1);
    }
    
    public object Czas(Time t) {
		if (debug)
			return t;
		return Soneta.Tools.Math.Round(t.TotalHours/1000.0, 1);
    }
    
    static void Msg(object value) {
    }

    static void Trace(object value) {
        if (trace != null)
            trace.WriteLine(value == null ? "(null)" : value.ToString());
    }		        
		    
		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<p>
				<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
				<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie dla GUS Z-03|</strong>Rok: <strong>%ROK%|</strong>Kwartał: <strong>%KWARTAŁ%"
					runat="server"></eb:ReportHeader>
			</p>
			<P>
				<TABLE id="Table1" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD align="center" width="20%"><FONT size="2">1. Symbol PKD</FONT></TD>
						<TD align="center" width="20%"><FONT size="2">2. Przeciętna liczba zatrudnionych</FONT></TD>
						<TD align="center" width="20%"><FONT size="2">3. Pracujący w osobach</FONT></TD>
						<TD align="center"><FONT size="2">4. Czas przepracowany<BR>
								<STRONG>(w tyś. godzin z jednym znakiem po przecinku)</STRONG></FONT></TD>
					</TR>
					<TR>
						<TD align="center">
							<ea:DataLabel id="pkd" runat="server"></ea:DataLabel></TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="etaty" runat="server"></ea:DataLabel></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="osoby" runat="server"></ea:DataLabel></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="czas" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P>
				<TABLE id="Table2" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD colSpan="4"><FONT size="2">Wynagrodzenie brutto <STRONG>w tyś. zł</STRONG> osób 
								wykazanych w pozycji 2</FONT></TD>
					</TR>
					<TR>
						<TD width="60%" colSpan="2"><FONT size="2">ogółem</FONT></TD>
						<TD width="5%">
							<P align="center"><FONT size="2">5</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="brutto" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD width="10%"><FONT size="2">w tym</FONT></TD>
						<TD><FONT size="2">wypłaty z tytułu udziału w zysku lub w nadwyżce bilansowej w 
								spółdzielniach</FONT></TD>
						<TD>
							<P align="center"><FONT size="2">6</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="spółdzielnie" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD><FONT size="2">dodatkowe wynagrodzenie roczne dla pracowników jednostek sfery 
								budżetowej</FONT></TD>
						<TD>
							<P align="center"><FONT size="2">7</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="budżet" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD><FONT size="2">składki na ubezpieczenie emerytalne, rentowe i chorobowe opłacone 
								przez ubezpieczonych</FONT></TD>
						<TD>
							<P align="center"><FONT size="2">8</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="zus" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD><FONT size="2">podatek dochodowy od osób fizycznych <STRONG><EM>(przed odliczeniem składki 
										na powszechne ubezpieczenie zdrowotne)</EM></STRONG></FONT></TD>
						<TD>
							<P align="center"><FONT size="2">9</FONT></P>
						</TD>
						<TD>
							<P align="right">
								<ea:DataLabel id="fis" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P>
				<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter></P>
		</form>
	</body>
</HTML>
